var Sequelize = require('sequelize'),
    fs = require('fs'),
    output = require('./../models/MyConsole'),
    parametersDB = JSON.parse(fs.readFileSync(__dirname + '/../parameters.json')).databaseConfiguration,
    sequelize = new Sequelize(parametersDB.databaseName, parametersDB.username, parametersDB.password, parametersDB.details);

// load models
var databaseModels = [
    'Message'
];
databaseModels.forEach(function(model) {
    module.exports[model] = sequelize.import(__dirname + '/models/' + model);
    module.exports[model].sync().success(function(){
        output.info('Table ' + model + ' sync');
        sequelize.query("CREATE INDEX group_idx ON messages (group_id)").success(function(){
            output.info('Table ' + model + ' add index group_idx');
        })
        .error(function(){
            output.warn('Table ' + model + ' index group_idx exist');
        });
    })
    .error(function(){
        output.error('Table ' + model + ' not sync');
    });
});
module.exports.sequelize = sequelize;